define(['Menu'], function() {
	'use strict';

	describe("The Menu directive", function (){
		var controller,
			scope,
			pageServiceMock,
			authenticationServiceMock,
			template,
			httpMock,
			snapRemoteMock,
			focusServiceMock;

		beforeEach( function () {
			module('angularTemplateApp');

			authenticationServiceMock = jasmine.createSpyObj('authenticationService',['logoutRedirectToLaunchpad', 'authenticate', 'isAuthenticated']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusPrimary', 'focusSecondary']);
			pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
			snapRemoteMock = jasmine.createSpyObj('snapRemote', ['getSnapper']);
			snapRemoteMock.getSnapper.andCallFake(function(){
				return { then: function() {} };
			});

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
				$provide.value('pageService', pageServiceMock);
				$provide.value('authenticationService', authenticationServiceMock);
				$provide.value('snapRemote', snapRemoteMock);
			});

			inject(function($compile, $rootScope, $httpBackend) {
				scope = $rootScope.$new();

				httpMock = $httpBackend;
				httpMock.whenGET('src/container/components/menu/menu_template.html').respond('<div></div>');

				httpMock.when('GET', 'src/container/components/menu/user-menu-items.json').respond([{
					"title": "Right Nav",
					"menuItems": [
						{
							"id":	"about",
							"text": "About",
							"modal": {
								"templateUrl": "src/ui-components/modals/about/about_template.html",
								"controller": "AboutController"
							},
							"align": "top"
						},
						{
							"id":	"logout",
							"text": "Logout",
							"link": "logout",
							"align": "bottom",
							"requiresAuth": true
						},
						{
							"id":	"login",
							"text": "Login",
							"link": "login",
							"align": "bottom",
							"requiresAuth": false
						}
					]
				}]);
				var element = angular.element("<div menu-include></div>");
				template = $compile(element)(scope);
				scope.$digest();
				controller = element.controller;

				httpMock.flush();
			});
		});

		describe("when logout is clicked", function (){
			beforeEach( function () {
				scope.openLink("logout");
			});

			it ("should call to redirect", function() {
				expect(authenticationServiceMock.logoutRedirectToLaunchpad).toHaveBeenCalled();
			});
		});

		describe("when login is clicked", function (){
			beforeEach( function () {
				scope.openLink("login");
			});

			it ("should call to authenticate", function() {
				expect(authenticationServiceMock.authenticate).toHaveBeenCalled();
			});
		});
	});
});